var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MemoryAnalyzer;
(function (MemoryAnalyzer) {
    var SnapshotViewController = (function () {
        function SnapshotViewController(storageId) {
            this._storageId = storageId;
            this.model = new SnapshotViewModel();
            this.model.progressText = Plugin.Resources.getString("ProcessingSnapshot");
            this.view = new SnapshotView(this, this.model);
        }
        SnapshotViewController.prototype.getSnapshotDataViewController = function (viewType) {
            return new MemoryAnalyzer.SnapshotDataViewController(viewType, this.model.snapshot, this.view, this.model.displayObjectIDs, this.model.showBuiltIns);
        };
        SnapshotViewController.prototype.loadSnapshot = function (storageId, relativePaths, targetView) {
            var _this = this;
            if(!relativePaths || relativePaths.length !== 1) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1012"));
            }
            this._processedSource = [];
            this.model.targetView = targetView;
            var snapshotProcessor = new MemoryAnalyzer.SnapshotProcessor();
            new MemoryAnalyzer.SnapshotFile(storageId, relativePaths[0]).getSnapshotRawData(function (snapshotData) {
                snapshotProcessor.processSnapshotAsync(snapshotData, {
                    completed: _this.onSnapshotProcessingCompleted.bind(_this, snapshotProcessor),
                    failed: _this.onSnapshotProcessingFailed.bind(_this, snapshotProcessor),
                    dataReceived: _this.onPayloadDataReceived.bind(_this),
                    progress: _this.onSnapshotProgress.bind(_this)
                });
            }, this.onSnapshotProcessingFailed.bind(this, snapshotProcessor));
        };
        SnapshotViewController.prototype.onPayloadDataReceived = function (data) {
            this._processedSource = data;
        };
        SnapshotViewController.prototype.onSnapshotProcessingCompleted = function (snapshotProcessor, snapshotPayload) {
            snapshotProcessor.terminate();
            if(!snapshotPayload.data && this._processedSource && this._processedSource.length > 0) {
                snapshotPayload.data = MemoryAnalyzer.HeapObjectHelpers.getHeapMap(this._processedSource);
                this._processedSource = null;
            }
            var heapObjectMap = MemoryAnalyzer.HeapObjectHelpers.getHeapObjectMapFromNative(snapshotPayload.data);
            var snapshot = new MemoryAnalyzer.Snapshot(heapObjectMap, snapshotPayload.graph, snapshotPayload.pointerSize, false);
            this.model.snapshot = snapshot;
            if(snapshotPayload.filteredChildrenObjectIds) {
                for(var i = 0; i < snapshotPayload.filteredChildrenObjectIds.length; i++) {
                    Plugin.log(Plugin.Resources.getString("ObjectIdNotFound"), snapshotPayload.filteredChildrenObjectIds[i]);
                }
            }
            MemoryAnalyzer.Program.onIdle();
        };
        SnapshotViewController.prototype.onSnapshotProcessingFailed = function (snapshotProcessor, error) {
            snapshotProcessor.terminate();
            if(!error) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1013"));
            }
            this.model.latestSnapshotError = error;
            MemoryAnalyzer.Program.onIdle();
        };
        SnapshotViewController.prototype.onSnapshotProgress = function (progress) {
            this.model.progressText = Plugin.Resources.getString(progress.title);
            this.model.progressValue = progress.percentage;
        };
        return SnapshotViewController;
    })();
    MemoryAnalyzer.SnapshotViewController = SnapshotViewController;    
    var SnapshotPayloadResultMerger = (function () {
        function SnapshotPayloadResultMerger() { }
        return SnapshotPayloadResultMerger;
    })();
    MemoryAnalyzer.SnapshotPayloadResultMerger = SnapshotPayloadResultMerger;    
    var SnapshotViewModel = (function (_super) {
        __extends(SnapshotViewModel, _super);
        function SnapshotViewModel() {
                _super.call(this);
            this._latestSnapshotError = null;
            this._displayObjectIDs = false;
            this._showBuiltIns = false;
        }
        Object.defineProperty(SnapshotViewModel.prototype, "displayObjectIDs", {
            get: function () {
                return this._displayObjectIDs;
            },
            set: function (v) {
                if(this._displayObjectIDs !== v) {
                    this._displayObjectIDs = v;
                    this.raisePropertyChanged("displayObjectIDs");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotViewModel.prototype, "showBuiltIns", {
            get: function () {
                return this._showBuiltIns;
            },
            set: function (v) {
                if(this._showBuiltIns !== v) {
                    this._showBuiltIns = v;
                    this.raisePropertyChanged("showBuiltIns");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotViewModel.prototype, "snapshot", {
            get: function () {
                return this._snapshot;
            },
            set: function (v) {
                if(this._snapshot !== v) {
                    this._snapshot = v;
                    this.raisePropertyChanged("snapshot");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotViewModel.prototype, "latestSnapshotError", {
            get: function () {
                return this._latestSnapshotError;
            },
            set: function (v) {
                if(this._latestSnapshotError !== v) {
                    this._latestSnapshotError = v;
                    this.raisePropertyChanged("latestSnapshotError");
                    MemoryAnalyzer.Program.reportError(v, "SnapshotProcessingFailure");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotViewModel.prototype, "progressText", {
            get: function () {
                return this._progressText;
            },
            set: function (v) {
                if(this._progressText !== v) {
                    this._progressText = v;
                    this.raisePropertyChanged("progressText");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotViewModel.prototype, "progressValue", {
            get: function () {
                return this._progressValue;
            },
            set: function (v) {
                if(this._progressValue !== v) {
                    this._progressValue = v;
                    this.raisePropertyChanged("progressValue");
                }
            },
            enumerable: true,
            configurable: true
        });
        return SnapshotViewModel;
    })(MemoryAnalyzer.Controls.ObservableViewModel);
    MemoryAnalyzer.SnapshotViewModel = SnapshotViewModel;    
    var SnapshotView = (function (_super) {
        __extends(SnapshotView, _super);
        function SnapshotView(controller, model) {
                _super.call(this, "SnapshotTabTemplate");
            this._controller = controller;
            this._model = model;
            this._model.displayObjectIDs = MemoryAnalyzer.Program.userSettings.displayObjectIDs;
            this._model.showBuiltIns = MemoryAnalyzer.Program.userSettings.showBuiltIns;
            this._model.registerPropertyChanged(this);
            this._snapshotDataNavigation = new Common.Controls.Control(this.findElement("snapshotDataNavigation"));
            this._snapshotProcessingProgressDiv = this.findElement("snapshotProcessingProgressDiv");
            this._progressText = this.findElement("progressText");
            this._progressBar = this.findElement("progressBar");
            this._snapshotProcessingError = this.findElement("snapshotProcessingError");
            this._snapshotProcessingErrorMsg = this.findElement("snapshotProcessingErrorMsg");
            this.findElement("snapshotProcessingErrorLabel").innerText = Plugin.Resources.getString("ErrorWhileProcessing");
            var settingsMenuButton = this.findElement("settingsMenuButton");
            settingsMenuButton.setAttribute("data-plugin-vs-tooltip", Plugin.Resources.getString("SettingsMenuButtonTooltipText"));
            settingsMenuButton.setAttribute("aria-label", Plugin.Resources.getString("SettingsMenuButtonTooltipText"));
            this._settingsMenu = new MemoryAnalyzer.Controls.MenuControl(settingsMenuButton);
            this._settingsMenu.addToggleItem(Plugin.Resources.getString("ShowBuiltIns"), this.toggleShowBuiltins.bind(this), this._model.showBuiltIns, 3);
            this._settingsMenu.addToggleItem(Plugin.Resources.getString("DisplayObjectIDs"), this.toggleDisplayObjectIDs.bind(this), this._model.displayObjectIDs, 3);
            MemoryAnalyzer.Extensions.Session.addViewTypeEventListener(this.onViewTypeChange.bind(this));
            this.uiUpdateViews();
            this.updateProgress();
        }
        Object.defineProperty(SnapshotView.prototype, "currentView", {
            get: function () {
                if(this._tabControl && this._tabControl.selectedItem) {
                    return this._tabControl.selectedItem.content;
                }
                return null;
            },
            enumerable: true,
            configurable: true
        });
        SnapshotView.prototype.switchToView = function (viewType) {
            this._tabControl.selectedItem = this._tabControl.getTab(viewType);
        };
        SnapshotView.prototype.onPropertyChanged = function (propertyName) {
            switch(propertyName) {
                case "snapshot": {
                    this.uiUpdateViews();
                    break;

                }
                case "latestSnapshotError": {
                    this.updateSnapshotError();
                    break;

                }
                case "progressText":
                case "progressValue": {
                    this.updateProgress();
                    break;

                }
            }
        };
        SnapshotView.prototype.updateProgress = function () {
            if(this._model.progressText) {
                this._progressText.innerText = this._model.progressText;
            }
            if(this._model.progressValue) {
                this._progressBar.value = this._model.progressValue;
            }
        };
        SnapshotView.prototype.onViewTypeChange = function (args) {
            if(this._tabControl) {
                var title = args.viewType;
                for(var i = 0; i < this._tabControl.length(); i++) {
                    var tabItem = this._tabControl.getTab(i);
                    if(tabItem.title === title) {
                        this._tabControl.selectedItem = tabItem;
                    }
                }
            }
        };
        SnapshotView.prototype.toggleShowBuiltins = function () {
            this._model.showBuiltIns = !this._model.showBuiltIns;
            return this._model.showBuiltIns;
        };
        SnapshotView.prototype.toggleDisplayObjectIDs = function () {
            this._model.displayObjectIDs = !this._model.displayObjectIDs;
            return this._model.displayObjectIDs;
        };
        SnapshotView.prototype.updateSnapshotError = function () {
            var error = this._model.latestSnapshotError;
            if(error) {
                this.showProgress(false);
                this._snapshotProcessingErrorMsg.innerText = MemoryAnalyzer.ErrorFormatter.format(error);
                this._snapshotProcessingError.style.display = "block";
            } else {
                this._snapshotProcessingErrorMsg.innerText = "";
                this._snapshotProcessingError.style.display = "none";
            }
        };
        SnapshotView.prototype.getNewTab = function (dataViewType) {
            var newTab = new MemoryAnalyzer.SnapshotDataViewTab(this._controller.getSnapshotDataViewController(dataViewType));
            this._model.registerPropertyChanged(newTab.controller.model);
            return newTab;
        };
        SnapshotView.prototype.uiUpdateViews = function () {
            this.updateSnapshotError();
            if(this._tabControl) {
                for(var i = 0; i < this._tabControl.length(); i++) {
                    var tabToRemove = this._tabControl.getTab(i);
                    this._model.removePropertyChanged((tabToRemove).controller.model);
                }
                this._snapshotDataNavigation.removeChild(this._tabControl);
            }
            if(this._model.snapshot) {
                this._snapshotDataNavigation.rootElement.classList.remove("snapshotDataNavigationHidden");
                this.showProgress(false);
                this._tabControl = new MemoryAnalyzer.Controls.TabControl();
                var dataViewTypes = Common.Enum.GetValues(MemoryAnalyzer.DataViewType);
                for(var i = 0; i < dataViewTypes.length; i++) {
                    var dataViewType = dataViewTypes[i];
                    var tabItem = this.getNewTab(dataViewType);
                    this._tabControl.addTab(tabItem);
                    if(tabItem.title === this._model.targetView) {
                        this._tabControl.selectedItem = tabItem;
                    }
                }
                this._snapshotDataNavigation.appendChild(this._tabControl);
            } else {
                this._snapshotDataNavigation.rootElement.classList.add("snapshotDataNavigationHidden");
                this.showProgress(true);
            }
        };
        SnapshotView.prototype.showProgress = function (show) {
            if(show) {
                this._snapshotProcessingProgressDiv.classList.remove("snapshotProcessingProgressDivHidden");
            } else {
                this._snapshotProcessingProgressDiv.classList.add("snapshotProcessingProgressDivHidden");
            }
        };
        return SnapshotView;
    })(Common.Controls.TemplateControl);
    MemoryAnalyzer.SnapshotView = SnapshotView;    
})(MemoryAnalyzer || (MemoryAnalyzer = {}));
//@ sourceMappingURL=snapshotView.js.map

// SIG // Begin signature block
// SIG // MIIalQYJKoZIhvcNAQcCoIIahjCCGoICAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFBWL9PumYwgR
// SIG // ZTlILuyiNJpxtzAmoIIVeTCCBLowggOioAMCAQICCmEC
// SIG // jkIAAAAAAB8wDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OFoXDTEz
// SIG // MDQwOTIyMjU1OFowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpGNTI4LTM3NzctOEE3NjElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJbsjkdN
// SIG // VMJclYDXTgs9v5dDw0vjYGcRLwFNDNjRRi8QQN4LpFBS
// SIG // EogLQ3otP+5IbmbHkeYDym7sealqI5vNYp7NaqQ/56ND
// SIG // /2JHobS6RPrfQMGFVH7ooKcsQyObUh8yNfT+mlafjWN3
// SIG // ezCeCjOFchvKSsjMJc3bXREux7CM8Y9DSEcFtXogC+Xz
// SIG // 78G69LPYzTiP+yGqPQpthRfQyueGA8Azg7UlxMxanMTD
// SIG // 2mIlTVMlFGGP+xvg7PdHxoBF5jVTIzZ3yrDdmCs5wHU1
// SIG // D92BTCE9djDFsrBlcylIJ9jC0rCER7t4utV0A97XSxn3
// SIG // U9542ob3YYgmM7RHxqBUiBUrLHUCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBQv6EbIaNNuT7Ig0N6JTvFH7kjB8jAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBz/30unc2NiCt8feNeFXHp
// SIG // aGLwCLZDVsRcSi1o2PlIEZHzEZyF7BLUVKB1qTihWX91
// SIG // 7sb1NNhUpOLQzHyXq5N1MJcHHQRTLDZ/f/FAHgybgOIS
// SIG // CiA6McAHdWfg+jSc7Ij7VxzlWGIgkEUvXUWpyI6zfHJt
// SIG // ECfFS9hvoqgSs201I2f6LNslLbldsR4F50MoPpwFdnfx
// SIG // Jd4FRxlt3kmFodpKSwhGITWodTZMt7MIqt+3K9m+Kmr9
// SIG // 3zUXzD8Mx90Gz06UJGMgCy4krl9DRBJ6XN0326RFs5E6
// SIG // Eld940fGZtPPnEZW9EwHseAMqtX21Tyi4LXU+Bx+BFUQ
// SIG // axj0kc1Rp5VlMIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSIMIIEhAIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGqMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBSui5oNHgroA50rLAYatXeE
// SIG // rhmXhjBKBgorBgEEAYI3AgEMMTwwOqAggB4AcwBuAGEA
// SIG // cABzAGgAbwB0AFYAaQBlAHcALgBqAHOhFoAUaHR0cDov
// SIG // L21pY3Jvc29mdC5jb20wDQYJKoZIhvcNAQEBBQAEggEA
// SIG // 3oBb21GZgIWFFj/9MNx2zYoqy0/l9SDyrtM7DYGcL4Ko
// SIG // +i8MUV5K322K6xhEUJZMcJ9/Z2zGAB0O14D+deLPelZh
// SIG // 4NDS5ikO9dSAIR1ezzK4fNgHF1At2msBARmxmxQqEy6q
// SIG // 0/qNnzDQLZXPUjwXCNNkBCAaRbuqTw56X/luDCjTJwl0
// SIG // mBVQ0YQayIe6XXkLH5so81QFTUrHy2MVndBbZI7m+F//
// SIG // 3/XRREbo2FxNpxac1AkLPUFLgcM0PjLh66D8AcqES8PR
// SIG // T8uEdLJw+6xpadIg3dsi3rvOwcUhVIO7g5Vu4UcUXSa2
// SIG // 56a5w2+SWJGua5mr/yLbrV2NmnuTzq2A6KGCAh8wggIb
// SIG // BgkqhkiG9w0BCQYxggIMMIICCAIBATCBhTB3MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQg
// SIG // VGltZS1TdGFtcCBQQ0ECCmECjkIAAAAAAB8wCQYFKw4D
// SIG // AhoFAKBdMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEw
// SIG // HAYJKoZIhvcNAQkFMQ8XDTEzMDMxNTA2MzM1OVowIwYJ
// SIG // KoZIhvcNAQkEMRYEFFj1UmNSUBU+5WoomipKcmLYMwGU
// SIG // MA0GCSqGSIb3DQEBBQUABIIBAFlhhJoXrUEyKMzpZ8Ot
// SIG // ErvEfDS06yFC7pi3M4odKkD1RwZxgF7cLxj7mkAZEaE9
// SIG // ww+rzfhU4yIGtw11iJ07PcYaxZCbGLB+jL+piBLfQCIN
// SIG // Cb6LNXmx9sLSlDKawg9bvGbZmDZAae9mqHT/dG3+G9TF
// SIG // XLK+v0AlCn7c9ivwitUzUpwxbljTcRqtHjdE23clcTyE
// SIG // jYZF7CIECaHBXrRy0ot7uQWFXTr35u972J1xokgzH4jV
// SIG // wKJQASlxW8j7jzrrdDSODLU6B46frH/I/2EvTVk2jBsy
// SIG // Fp/5cm/jb8v430vH9JteCqTH8jm4QUw9La7hPVQRr0Yn
// SIG // Nr+6OY5ZOf6mpJY=
// SIG // End signature block
